/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsManager;
import net.valhelsia.valhelsia_core.common.network.NetworkHandler;
import net.valhelsia.valhelsia_core.common.network.UpdateCosmeticsPacket;

public record UploadCosmeticsPacket(UUID uuid, CompoundTag activeCosmetics) {
    public static void encode(UploadCosmeticsPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.uuid);
        buffer.m_130079_(packet.activeCosmetics);
    }

    public static UploadCosmeticsPacket decode(FriendlyByteBuf buffer) {
        return new UploadCosmeticsPacket(buffer.m_130259_(), buffer.m_130260_());
    }

    public static void consume(UploadCosmeticsPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                CosmeticsManager cosmeticsManager = CosmeticsManager.getInstance();
                cosmeticsManager.setActiveCosmeticsForPlayer(packet.uuid, packet.activeCosmetics);
                cosmeticsManager.getLoadedPlayers().add(packet.uuid);
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> ((NetworkEvent.Context)context).getSender()), (Object)new UpdateCosmeticsPacket(packet.uuid, packet.activeCosmetics));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

